/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class SimpleConfigTextUtil {
    protected static final Pattern NEW_LINE = Pattern.compile("\\R");
    protected static final Pattern FS_PATTERN = Pattern.compile("%(?:(?<index>\\d+)\\$)?(?<flags>[-#+ 0,(<]*)?(?<width>\\d+)?(?<precision>\\.\\d+)?(?<t>[tT])?(?<conversion>[a-zA-Z%])");
    protected static final Pattern FORMATTING_CODE_PATTERN = Pattern.compile("\u00a7[\\da-fklmnor]");
    protected static final Pattern FS_INDEX_PATTERN = Pattern.compile("(?<pre>(?<!%)(?:%%)*+%)(?:(?<d>\\d+)\\$)?(?<flags>[-#+ 0,(<]*)(?<pos>[a-zA-Z])");

    @NotNull
    public static String stripFormattingCodes(@NotNull String text) {
        return FORMATTING_CODE_PATTERN.matcher(text).replaceAll("");
    }

    @NotNull
    public static String toTitleCase(@NotNull String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    @NotNull
    public static List<Component> paragraph(@NotNull String key, Object ... lines) {
        ArrayList<Component> result = new ArrayList<Component>();
        ArrayList<Object> args = new ArrayList<Object>();
        for (Object line : lines) {
            if (line instanceof String) {
                result.addAll(SimpleConfigTextUtil.splitTtc(key, args.toArray()));
                key = (String)line;
                args.clear();
                continue;
            }
            args.add(line);
        }
        result.addAll(SimpleConfigTextUtil.splitTtc(key, args.toArray()));
        return result;
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public static MutableComponent subText(@NotNull Component component, int start) {
        int length = component.getString().length();
        if (start < 0 || start > length) {
            throw new StringIndexOutOfBoundsException(start);
        }
        SubTextVisitor visitor = new SubTextVisitor(start, Integer.MAX_VALUE);
        component.m_7451_((FormattedText.StyledContentConsumer)visitor, Style.f_131099_);
        return visitor.getResult();
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public static MutableComponent subText(@NotNull Component component, int start, int end) {
        int length = component.getString().length();
        if (start < 0 || start > length) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end < 0 || end > length) {
            throw new StringIndexOutOfBoundsException(end);
        }
        SubTextVisitor visitor = new SubTextVisitor(start, end);
        component.m_7451_((FormattedText.StyledContentConsumer)visitor, Style.f_131099_);
        return visitor.getResult();
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public static MutableComponent applyStyle(@NotNull Component component, ChatFormatting style, int start, int end) {
        return SimpleConfigTextUtil.applyStyle(component, Style.f_131099_.m_131157_(style), start, end);
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public static MutableComponent applyStyle(@NotNull Component component, Style style, int start, int end) {
        int length = component.getString().length();
        SimpleConfigTextUtil.checkBounds(start, length);
        SimpleConfigTextUtil.checkBounds(end, length);
        if (start == end) {
            return component.m_6881_();
        }
        ApplyStyleVisitor visitor = new ApplyStyleVisitor(style, start, end);
        component.m_7451_((FormattedText.StyledContentConsumer)visitor, Style.f_131099_);
        return visitor.getResult();
    }

    private static void checkBounds(int index, int length) {
        if (index < 0 || index > length) {
            throw new StringIndexOutOfBoundsException(index);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @ApiStatus.Internal
    @NotNull
    public static List<Component> splitTtc(@NotNull String key, Object ... args) {
        List<Component> ls = SimpleConfigTextUtil.optSplitTtc(key, args);
        if (ls.isEmpty()) {
            ls.add((Component)Component.m_237113_((String)key));
        }
        return ls;
    }

    @OnlyIn(value=Dist.CLIENT)
    @ApiStatus.Internal
    @NotNull
    public static List<Component> optSplitTtc(@NotNull String key, Object ... args) {
        if (I18n.m_118936_((String)key)) {
            String f = SimpleConfigTextUtil.addExplicitFormatIndexes(Language.m_128107_().m_6834_(key));
            String[] lines = NEW_LINE.split(f);
            ArrayList<Component> components = new ArrayList<Component>();
            for (String line : lines) {
                Matcher m = FS_PATTERN.matcher(line);
                MutableComponent built = Component.m_237113_((String)"");
                int cursor = 0;
                while (m.find()) {
                    int i;
                    if ("%".equals(m.group("conversion"))) {
                        built.m_130946_("%");
                        continue;
                    }
                    int s = m.start();
                    if (s > cursor) {
                        built.m_130946_(line.substring(cursor, s));
                    }
                    if ((i = Integer.parseInt(m.group("index")) - 1) < args.length) {
                        if (args[i] instanceof Component) {
                            built.m_7220_((Component)args[i]);
                        } else {
                            built.m_130946_(String.format(m.group(), args));
                        }
                    }
                    cursor = m.end();
                }
                if (line.length() > cursor) {
                    built.m_130946_(line.substring(cursor));
                }
                components.add((Component)built);
            }
            return components;
        }
        return Lists.newArrayList();
    }

    protected static String addExplicitFormatIndexes(String fmt) {
        Matcher m = FS_INDEX_PATTERN.matcher(fmt);
        StringBuilder sb = new StringBuilder();
        int last_gen = -1;
        int last = -1;
        while (m.find()) {
            String g = m.group("d");
            String f = m.group("flags");
            String rep = g + f;
            if (f.contains("<")) {
                if (last >= 0) {
                    rep = last + 1 + "\\$" + f.replace("<", "");
                }
            } else if (g == null || g.isEmpty()) {
                last = ++last_gen;
                rep = last_gen + 1 + "\\$" + f;
            } else {
                last = Integer.parseInt(g) - 1;
                rep = rep + "\\$";
            }
            m.appendReplacement(sb, "${pre}" + rep + "${pos}");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @ApiStatus.Internal
    public static Component asComponent(FormattedCharSequence sequence) {
        return new FormattedCharSequenceConverter(sequence).convert();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class SubTextVisitor
    implements FormattedText.StyledContentConsumer<Boolean> {
        private final int start;
        private final int end;
        private MutableComponent result = null;
        private int length = 0;

        private SubTextVisitor(int start, int end) {
            this.start = start;
            this.end = end;
        }

        private void appendFragment(String fragment, Style style) {
            if (this.result == null) {
                this.result = Component.m_237113_((String)fragment).m_130948_(style);
            } else {
                this.result.m_7220_((Component)Component.m_237113_((String)fragment).m_130948_(style));
            }
        }

        @NotNull
        public Optional<Boolean> m_7164_(@NotNull Style style, @NotNull String contents) {
            int l = contents.length();
            if (this.length + l > this.end) {
                this.appendFragment(contents.substring(Math.max(0, this.start - this.length), this.end - this.length), style);
                return Optional.of(true);
            }
            if (this.length + l >= this.start) {
                this.appendFragment(contents.substring(Math.max(0, this.start - this.length)), style);
            }
            this.length += l;
            return Optional.empty();
        }

        public MutableComponent getResult() {
            return this.result != null ? this.result : Component.m_237119_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static final class ApplyStyleVisitor
    implements FormattedText.StyledContentConsumer<Boolean> {
        private final Style style;
        private final int start;
        private final int end;
        private MutableComponent result = null;
        private int length = 0;

        private ApplyStyleVisitor(Style style, int start, int end) {
            this.style = style;
            this.start = start;
            this.end = end;
        }

        @NotNull
        public Optional<Boolean> m_7164_(@NotNull Style style, @NotNull String text) {
            int l = text.length();
            if (l + this.length <= this.start || this.length >= this.end) {
                this.appendFragment(text, style);
            } else {
                int relStart = Math.max(0, this.start - this.length);
                int relEnd = Math.min(l, this.end - this.length);
                if (relStart > 0) {
                    this.appendFragment(text.substring(0, relStart), style);
                }
                if (relEnd > relStart) {
                    this.appendFragment(text.substring(relStart, relEnd), this.style.m_131146_(style));
                }
                if (relEnd < l) {
                    this.appendFragment(text.substring(relEnd), style);
                }
            }
            this.length += l;
            return Optional.empty();
        }

        public MutableComponent getResult() {
            return this.result != null ? this.result : Component.m_237119_();
        }

        private void appendFragment(String fragment, Style style) {
            if (this.result == null) {
                this.result = Component.m_237113_((String)fragment).m_6270_(style);
            } else {
                this.result.m_7220_((Component)Component.m_237113_((String)fragment).m_6270_(style));
            }
        }
    }

    private static class FormattedCharSequenceConverter {
        private Style style = Style.f_131099_;
        private MutableComponent component = null;
        private StringBuilder builder = new StringBuilder();
        private final FormattedCharSequence sequence;

        public FormattedCharSequenceConverter(FormattedCharSequence sequence) {
            this.sequence = sequence;
        }

        public MutableComponent convert() {
            this.sequence.m_13731_(this::append);
            if (this.builder.length() > 0) {
                this.flush();
            }
            return this.component != null ? this.component : Component.m_237119_();
        }

        private boolean append(int width, Style style, int ch) {
            if (this.style != style) {
                if (this.builder.length() > 0) {
                    this.flush();
                    this.builder = new StringBuilder();
                }
                this.style = style;
            }
            this.builder.appendCodePoint(ch);
            return true;
        }

        private void flush() {
            if (this.component == null) {
                this.component = Component.m_237113_((String)this.builder.toString()).m_6270_(this.style);
            } else {
                this.component.m_7220_((Component)Component.m_237113_((String)this.builder.toString()).m_6270_(this.style));
            }
        }
    }
}

