/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api;

import endorh.simpleconfig.api.ConfigBuilderFactoryProxy;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.SimpleConfigCategory;
import endorh.simpleconfig.api.SimpleConfigGUIManagerProxy;
import endorh.simpleconfig.api.SimpleConfigGroup;
import endorh.simpleconfig.api.SimpleConfigProxy;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SimpleConfig
extends ConfigEntryHolder {
    @ApiStatus.Internal
    public static final String MOD_ID = "simpleconfig";

    public static boolean registerConfig(Type type, @NotNull Class<?> configClass) {
        return SimpleConfig.registerConfig(null, type, configClass);
    }

    public static boolean registerConfig(@Nullable String modId, Type type, @NotNull Class<?> configClass) {
        if (!SimpleConfigProxy.isRuntimePresent()) {
            LogManager.getLogger().warn("Config file for mod " + SimpleConfigProxy.getModNameOrId(modId) + "(" + modId + ") cannot be created because the Simple Config mod is not present.\n  Install Simple Config to modify the configuration of this mod:\n    https://www.curseforge.com/minecraft/mc-mods/simple-config");
            return false;
        }
        ConfigBuilderFactoryProxy.config(modId, type, configClass).buildAndRegister();
        return true;
    }

    public boolean isWrapper();

    public Optional<Path> getFilePath();

    default public Optional<Path> getFilePath(String category) {
        return this.getFilePath();
    }

    @ApiStatus.Internal
    public String getFileName();

    @NotNull
    public SimpleConfigCategory getCategory(String var1);

    @NotNull
    public SimpleConfigGroup getGroup(String var1);

    public boolean canEdit();

    public Type getType();

    public String getModId();

    public String getModName();

    @OnlyIn(value=Dist.CLIENT)
    public static boolean hasConfigGUI(String modId) {
        return SimpleConfigGUIManagerProxy.getSimpleConfigGUIManager().hasConfigGUI(modId);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public static Screen getConfigGUI(String modId, Screen parent) {
        return SimpleConfigGUIManagerProxy.getSimpleConfigGUIManager().getConfigGUI(modId, parent);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public static Screen getConfigGUI(String modId) {
        return SimpleConfigGUIManagerProxy.getSimpleConfigGUIManager().getConfigGUI(modId);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void showConfigGUI(String modId) {
        SimpleConfigGUIManagerProxy.getSimpleConfigGUIManager().showConfigGUI(modId);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void showModListGUI() {
        SimpleConfigGUIManagerProxy.getSimpleConfigGUIManager().showModListGUI();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void showConfigHotkeysGUI() {
        SimpleConfigGUIManagerProxy.getSimpleConfigGUIManager().showConfigHotkeysGUI();
    }

    public static enum Type {
        CLIENT(ModConfig.Type.CLIENT, true, false),
        COMMON(ModConfig.Type.COMMON, true, true),
        SERVER(ModConfig.Type.SERVER, false, true);

        private static final Map<String, Type> BY_ALIAS;
        private static final Map<ModConfig.Type, Type> BY_CONFIG_TYPE;
        private static final Set<Type> LOCAL_TYPES;
        private static final Set<Type> REMOTE_TYPES;
        @NotNull
        private final ModConfig.Type type;
        private final boolean isLocal;
        private final boolean isRemote;
        @NotNull
        private final String alias;

        public static Set<Type> localTypes() {
            return LOCAL_TYPES;
        }

        public static Set<Type> remoteTypes() {
            return REMOTE_TYPES;
        }

        public static Type fromAlias(String alias) {
            return BY_ALIAS.get(alias);
        }

        public static Type fromConfigType(ModConfig.Type type) {
            return BY_CONFIG_TYPE.get(type);
        }

        private Type(ModConfig.Type type, boolean isLocal, boolean isRemote) {
            this.type = type;
            this.isLocal = isLocal;
            this.isRemote = isRemote;
            this.alias = type.extension();
        }

        public boolean isLocal() {
            return this.isLocal;
        }

        public boolean isRemote() {
            return this.isRemote;
        }

        @NotNull
        public ModConfig.Type asConfigType() {
            return this.type;
        }

        public EditType asEditType(boolean remote) {
            return Arrays.stream(EditType.values()).filter(t -> t.getType() == this && t.isOnlyRemote() == remote).findFirst().orElseGet(() -> Arrays.stream(EditType.values()).filter(t -> t.getType() == this).findFirst().orElse(null));
        }

        @NotNull
        public String getAlias() {
            return this.alias;
        }

        static {
            BY_ALIAS = (Map)Util.m_137469_(new HashMap(Type.values().length), m -> {
                for (Type v : Type.values()) {
                    m.put(v.getAlias(), v);
                }
            });
            BY_CONFIG_TYPE = (Map)Util.m_137469_(new HashMap(Type.values().length), m -> {
                for (Type v : Type.values()) {
                    m.put(v.asConfigType(), v);
                }
            });
            LOCAL_TYPES = (Set)Util.m_137469_(Collections.newSetFromMap(new EnumMap(Type.class)), s -> Arrays.stream(Type.values()).filter(Type::isLocal).forEach(s::add));
            REMOTE_TYPES = (Set)Util.m_137469_(Collections.newSetFromMap(new EnumMap(Type.class)), s -> Arrays.stream(Type.values()).filter(Type::isRemote).forEach(s::add));
        }
    }

    public static class ConfigReflectiveOperationException
    extends RuntimeException {
        public ConfigReflectiveOperationException(String message, Exception cause) {
            super(message, cause);
        }
    }

    public static class InvalidConfigValueTypeException
    extends RuntimeException {
        public InvalidConfigValueTypeException(String path) {
            super("Invalid type requested for config value \"" + path + "\"");
        }

        public InvalidConfigValueTypeException(String path, Throwable cause) {
            super("Invalid type requested for config value \"" + path + "\"", cause);
        }

        public InvalidConfigValueTypeException(String path, Throwable cause, String extra) {
            super("Invalid type requested for config value \"" + path + "\"\n  " + extra, cause);
        }
    }

    public static class UnInvertibleBakingTransformationException
    extends RuntimeException {
        public UnInvertibleBakingTransformationException(String path) {
            super("Baking transformation of config entry \"" + path + "\" does not support write access");
        }
    }

    public static class InvalidDefaultConfigValueException
    extends RuntimeException {
        public InvalidDefaultConfigValueException(String path, Object value) {
            super("Invalid default config value set for config entry \"" + path + "\": " + value);
        }
    }

    public static class InvalidConfigValueException
    extends RuntimeException {
        public InvalidConfigValueException(String path, Object value) {
            super("Invalid config value set for config entry \"" + path + "\": " + value);
        }
    }

    public static class NoSuchConfigGroupError
    extends RuntimeException {
        public NoSuchConfigGroupError(String path) {
            super("Cannot find config group \"" + path + "\"");
        }
    }

    public static class NoSuchConfigCategoryError
    extends RuntimeException {
        public NoSuchConfigCategoryError(String path) {
            super("Cannot find config category \"" + path + "\"");
        }
    }

    public static class NoSuchConfigEntryError
    extends RuntimeException {
        public NoSuchConfigEntryError(String path) {
            super("Cannot find config entry \"" + path + "\"");
        }
    }

    public static enum EditType {
        CLIENT(Type.CLIENT, false, false),
        COMMON(Type.COMMON, false, false),
        SERVER_COMMON(Type.COMMON, true, true),
        SERVER(Type.SERVER, true, false);

        private static final Map<String, EditType> BY_ALIAS;
        private static final EditType[] LOCAL_TYPES;
        private static final EditType[] REMOTE_TYPES;
        @NotNull
        private final Type type;
        private final boolean isRemote;
        private final boolean onlyRemote;
        @NotNull
        private final String alias;

        public static EditType[] localTypes() {
            return LOCAL_TYPES;
        }

        public static EditType[] remoteTypes() {
            return REMOTE_TYPES;
        }

        public static EditType fromAlias(String extension) {
            return BY_ALIAS.get(extension);
        }

        private EditType(Type type, boolean isRemote, boolean onlyRemote) {
            this.type = type;
            this.isRemote = isRemote;
            this.onlyRemote = onlyRemote;
            this.alias = this.name().toLowerCase().replace('_', '-');
        }

        @NotNull
        public Type getType() {
            return this.type;
        }

        public boolean isRemote() {
            return this.isRemote;
        }

        public boolean isOnlyRemote() {
            return this.onlyRemote;
        }

        @NotNull
        public String getAlias() {
            return this.alias;
        }

        static {
            BY_ALIAS = (Map)Util.m_137469_(new HashMap(EditType.values().length), m -> {
                for (EditType v : EditType.values()) {
                    m.put(v.getAlias(), v);
                }
            });
            LOCAL_TYPES = (EditType[])Arrays.stream(EditType.values()).filter(editType -> !editType.isRemote()).toArray(EditType[]::new);
            REMOTE_TYPES = (EditType[])Arrays.stream(EditType.values()).filter(EditType::isRemote).toArray(EditType[]::new);
        }
    }
}

