/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api;

import endorh.simpleconfig.api.TooltipEntryBuilder;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface ErrorEntryBuilder<V, Config, Gui, Self extends TooltipEntryBuilder<V, Gui, Self>> {
    @Contract(pure=true)
    @NotNull
    public Self guiError(Function<Gui, Optional<Component>> var1);

    @Contract(pure=true)
    @NotNull
    default public Self guiErrorNullable(Function<Gui, Component> errorSupplier) {
        return this.guiError(v -> Optional.ofNullable((Component)errorSupplier.apply(v)));
    }

    @Contract(pure=true)
    @NotNull
    default public Self configErrorNullable(Function<Gui, Component> errorSupplier) {
        return this.guiError(v -> Optional.ofNullable((Component)errorSupplier.apply(v)));
    }

    @Contract(pure=true)
    @NotNull
    public Self error(Function<V, Optional<Component>> var1);

    @Contract(pure=true)
    @NotNull
    public Self configError(Function<Config, Optional<Component>> var1);

    @Contract(pure=true)
    @NotNull
    public Self withoutError();

    @Deprecated
    @Contract(pure=true)
    @NotNull
    default public Self check(Predicate<V> validator) {
        return this.error(v -> validator.test(v) ? Optional.empty() : Optional.of(Component.m_237115_((String)"simpleconfig.config.error.invalid_value_generic")));
    }

    @Contract(pure=true)
    @NotNull
    default public Self errorNullable(Function<V, Component> errorSupplier) {
        return this.error(v -> Optional.ofNullable((Component)errorSupplier.apply(v)));
    }
}

