/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api;

import com.google.common.collect.Maps;
import endorh.simpleconfig.api.SimpleConfigTextUtil;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntryTag
implements Comparable<EntryTag> {
    private static final Map<ChatFormatting, EntryTag> TAGS = Maps.newHashMap();
    private static final Map<ChatFormatting, EntryTag> BOOKMARKS = Maps.newHashMap();
    private static final Map<ChatFormatting, EntryTag> WRENCHES = Maps.newHashMap();
    public static final EntryTag REQUIRES_RESTART = EntryTag.translated(200, "Requires Restart!", SimpleConfigIcons.Entries.REQUIRES_RESTART, "simpleconfig.config.tag.requires_restart", null);
    public static final EntryTag EXPERIMENTAL = EntryTag.translated(300, "EXPERIMENTAL!", SimpleConfigIcons.Entries.EXPERIMENTAL, "simpleconfig.config.tag.experimental", null);
    public static final EntryTag ADVANCED = EntryTag.coloredWrench(ChatFormatting.GOLD);
    public static final EntryTag OPERATOR = EntryTag.translated(99, "Operator", SimpleConfigIcons.Entries.WRENCH.withTint(ChatFormatting.BLUE), "simpleconfig.config.tag.operator", null);
    public static final EntryTag NON_PERSISTENT = EntryTag.translated(400, null, SimpleConfigIcons.Entries.NOT_PERSISTENT, "simpleconfig.config.tag.not_persistent", null);
    private static int STAMP;
    private final int id = STAMP++;
    @Nullable
    private final String comment;
    private final int order;
    private final Icon icon;
    @Nullable
    private final Supplier<List<Component>> tooltip;
    private final Consumer<Integer> clickAction;

    @NotNull
    public static EntryTag coloredTag(ChatFormatting color) {
        String name = SimpleConfigTextUtil.toTitleCase(color.m_126666_());
        return TAGS.computeIfAbsent(color, c -> EntryTag.of(500 + color.m_126656_(), name + " tag", SimpleConfigIcons.Entries.TAG.withTint(color), () -> SimpleConfigTextUtil.splitTtc("simpleconfig.config.tag.tag", Component.m_237113_((String)name).m_130940_(color)), null));
    }

    @NotNull
    public static EntryTag coloredBookmark(ChatFormatting color) {
        String name = SimpleConfigTextUtil.toTitleCase(color.m_126666_());
        return BOOKMARKS.computeIfAbsent(color, c -> EntryTag.of(600 + color.m_126656_(), name + " bookmark", SimpleConfigIcons.Entries.BOOKMARK.withTint(color), () -> SimpleConfigTextUtil.splitTtc("simpleconfig.config.tag.bookmark", Component.m_237113_((String)name).m_130940_(color)), null));
    }

    @NotNull
    public static EntryTag coloredWrench(ChatFormatting color) {
        return WRENCHES.computeIfAbsent(color, c -> EntryTag.translated(100 + color.m_126656_(), "Advanced!", SimpleConfigIcons.Entries.WRENCH.withTint(color), "simpleconfig.config.tag.advanced", null));
    }

    @NotNull
    public static EntryTag copyTag(int order, String text, String tooltipTranslationKey) {
        return EntryTag.copyTag(order, text, () -> SimpleConfigTextUtil.splitTtc(tooltipTranslationKey, new Object[0]));
    }

    @NotNull
    public static EntryTag copyTag(int order, String text, Supplier<List<Component>> tooltip) {
        return EntryTag.of(order, null, SimpleConfigIcons.Entries.COPY, tooltip, b -> Minecraft.m_91087_().f_91068_.m_90911_(text));
    }

    @NotNull
    public static EntryTag translated(@Nullable String comment, Icon icon, String tooltipTranslationKey, @Nullable Consumer<Integer> clickAction) {
        return EntryTag.translated(0, comment, icon, tooltipTranslationKey, clickAction);
    }

    @NotNull
    public static EntryTag translated(int order, @Nullable String comment, Icon icon, String tooltipTranslationKey, @Nullable Consumer<Integer> clickAction) {
        return EntryTag.of(order, comment, icon, () -> SimpleConfigTextUtil.splitTtc(tooltipTranslationKey, new Object[0]), clickAction);
    }

    @NotNull
    public static EntryTag of(@Nullable String comment, Icon icon, @Nullable Supplier<List<Component>> tooltip, @Nullable Consumer<Integer> clickAction) {
        return EntryTag.of(0, comment, icon, tooltip, clickAction);
    }

    @NotNull
    public static EntryTag of(int order, @Nullable String comment, Icon icon, @Nullable Supplier<List<Component>> tooltip, @Nullable Consumer<Integer> clickAction) {
        return new EntryTag(order, comment, icon, tooltip, clickAction);
    }

    public EntryTag(int order, @Nullable String comment, Icon icon, @Nullable Supplier<List<Component>> tooltip, @Nullable Consumer<Integer> clickAction) {
        this.order = order;
        this.comment = comment;
        this.icon = icon;
        this.tooltip = tooltip;
        this.clickAction = clickAction;
    }

    public void onClick(int button) {
        if (this.clickAction != null) {
            this.clickAction.accept(button);
        }
    }

    public Icon getIcon() {
        return this.icon;
    }

    public List<Component> getTooltip() {
        return this.tooltip != null ? this.tooltip.get() : Collections.emptyList();
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    public int getOrder() {
        return this.order;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public int compareTo(@NotNull EntryTag o) {
        return new CompareToBuilder().append(this.order, o.order).append(this.id, o.id).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntryTag entryFlag = (EntryTag)o;
        return this.order == entryFlag.order && Objects.equals(this.icon, entryFlag.icon) && Objects.equals(this.comment, entryFlag.comment) && Objects.equals(this.tooltip, entryFlag.tooltip);
    }

    public int hashCode() {
        return Objects.hash(this.order, this.icon, this.comment, this.tooltip);
    }
}

