/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.api;

import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.ui.ConfigScreen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ConfigEntryHolder {
    @NotNull
    public SimpleConfig getRoot();

    @NotNull
    default public ConfigEntryHolder getParent() {
        throw new SimpleConfig.NoSuchConfigGroupError("");
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public ConfigScreen getGUI();

    default public boolean hasGUI() {
        if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
            return false;
        }
        return this.getGUI() != null;
    }

    @NotNull
    public ConfigEntryHolder getChild(String var1);

    public <T> T get(String var1);

    public <V> void setForGUI(String var1, V var2);

    public void setForGUI(String var1, Number var2);

    public boolean hasGUI(String var1);

    public <G> G getGUI(String var1);

    public <V> V getFromGUI(String var1);

    public <V> void set(String var1, V var2);

    default public ConfigEntryHolder markDirty() {
        this.markDirty(true);
        return this;
    }

    public void markDirty(boolean var1);

    public boolean isDirty();

    default public boolean getBoolean(String path) {
        try {
            return (Boolean)this.get(path);
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public char getChar(String path) {
        try {
            return ((Character)this.get(path)).charValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public byte getByte(String path) {
        try {
            return ((Number)this.get(path)).byteValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public short getShort(String path) {
        try {
            return ((Number)this.get(path)).shortValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public int getInt(String path) {
        try {
            return ((Number)this.get(path)).intValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public long getLong(String path) {
        try {
            return ((Number)this.get(path)).longValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public float getFloat(String path) {
        try {
            return ((Number)this.get(path)).floatValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public double getDouble(String path) {
        try {
            return ((Number)this.get(path)).doubleValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    public <T> T getBaked(String var1);

    default public boolean getBakedBoolean(String path) {
        try {
            return (Boolean)this.getBaked(path);
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public char getBakedChar(String path) {
        try {
            return ((Character)this.getBaked(path)).charValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public byte getBakedByte(String path) {
        try {
            return ((Number)this.getBaked(path)).byteValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public short getBakedShort(String path) {
        try {
            return ((Number)this.getBaked(path)).shortValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public int getBakedInt(String path) {
        try {
            return ((Number)this.getBaked(path)).intValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public long getBakedLong(String path) {
        try {
            return ((Number)this.getBaked(path)).longValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public float getBakedFloat(String path) {
        try {
            return ((Number)this.getBaked(path)).floatValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public double getBakedDouble(String path) {
        try {
            return ((Number)this.getBaked(path)).doubleValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    public <V> void setBaked(String var1, V var2);

    default public boolean getGUIBoolean(String path) {
        try {
            return (Boolean)this.getGUI(path);
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public char getGUIChar(String path) {
        try {
            return ((Character)this.getGUI(path)).charValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public byte getGUIByte(String path) {
        try {
            return ((Number)this.getGUI(path)).byteValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public short getGUIShort(String path) {
        try {
            return ((Number)this.getGUI(path)).shortValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public int getGUIInt(String path) {
        try {
            return ((Number)this.getGUI(path)).intValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public long getGUILong(String path) {
        try {
            return ((Number)this.getGUI(path)).longValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public float getGUIFloat(String path) {
        try {
            return ((Number)this.getGUI(path)).floatValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public double getGUIDouble(String path) {
        try {
            return ((Number)this.getGUI(path)).doubleValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public boolean getBooleanFromGUI(String path) {
        try {
            return (Boolean)this.getFromGUI(path);
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public byte getByteFromGUI(String path) {
        try {
            return ((Number)this.getFromGUI(path)).byteValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public short getShortFromGUI(String path) {
        try {
            return ((Number)this.getFromGUI(path)).shortValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public int getIntFromGUI(String path) {
        try {
            return ((Number)this.getFromGUI(path)).intValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public long getLongFromGUI(String path) {
        try {
            return ((Number)this.getFromGUI(path)).longValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public float getFloatFromGUI(String path) {
        try {
            return ((Number)this.getFromGUI(path)).floatValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public double getDoubleFromGUI(String path) {
        try {
            return ((Number)this.getFromGUI(path)).doubleValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    default public char getCharFromGUI(String path) {
        try {
            return ((Character)this.getFromGUI(path)).charValue();
        }
        catch (ClassCastException e) {
            throw new SimpleConfig.InvalidConfigValueTypeException(path, e);
        }
    }

    public <G> void setGUI(String var1, G var2);

    public void reset();

    public void reset(String var1);

    @OnlyIn(value=Dist.CLIENT)
    public boolean resetInGUI(String var1);

    @OnlyIn(value=Dist.CLIENT)
    public boolean restoreInGUI(String var1);
}

