/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig;

import com.mojang.blaze3d.platform.InputConstants;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.config.ClientConfig;
import endorh.simpleconfig.config.CommonConfig;
import endorh.simpleconfig.config.ServerConfig;
import endorh.simpleconfig.core.SimpleConfigDiscoverer;
import endorh.simpleconfig.core.SimpleConfigModConfig;
import endorh.simpleconfig.core.SimpleConfigNetworkHandler;
import endorh.simpleconfig.core.SimpleConfigResourcePresetHandler;
import endorh.simpleconfig.core.commands.SimpleConfigArgumentTypes;
import endorh.simpleconfig.grammar.nbt.SNBTLexer;
import endorh.simpleconfig.grammar.nbt.SNBTParser;
import endorh.simpleconfig.grammar.regex.RegexLexer;
import endorh.simpleconfig.grammar.regex.RegexParser;
import endorh.simpleconfig.highlight.HighlighterManagerImpl;
import endorh.simpleconfig.ui.hotkey.ExtendedKeyBindDispatcher;
import endorh.simpleconfig.ui.hotkey.ResourceConfigHotKeyGroupHandler;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.ApiStatus;

@Mod(value="simpleconfig")
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="simpleconfig", bus=Mod.EventBusSubscriber.Bus.MOD)
@ApiStatus.Internal
public class SimpleConfigMod {
    public static final String MOD_ID = "simpleconfig";
    public static SoundEvent UI_TAP;
    public static SoundEvent UI_DOUBLE_TAP;
    @OnlyIn(value=Dist.CLIENT)
    public static SimpleConfig CLIENT_CONFIG;
    public static SimpleConfig COMMON_CONFIG;
    public static SimpleConfig SERVER_CONFIG;
    public static final HighlighterManagerImpl JSON_HIGHLIGHTER_MANAGER;
    public static final SimpleConfigResourcePresetHandler RESOURCE_PRESET_HANDLER;
    public static final ResourceConfigHotKeyGroupHandler RESOURCE_HOT_KEY_GROUP_HANDLER;
    public static final SimpleConfigModConfig.LanguageReloadManager LANGUAGE_RELOAD_MANAGER;

    public SimpleConfigMod() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            CLIENT_CONFIG = ClientConfig.build();
        });
        COMMON_CONFIG = CommonConfig.build();
        SERVER_CONFIG = ServerConfig.build();
        SimpleConfigDiscoverer.discoverConfigs();
        SimpleConfigArgumentTypes.registerArgumentTypes();
        SimpleConfigNetworkHandler.registerPackets();
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (s, b) -> true));
    }

    @SubscribeEvent
    public static void registerReloadListener(RegisterParticleProvidersEvent event) {
        ReloadableResourceManager manager = (ReloadableResourceManager)Minecraft.m_91087_().m_91098_();
        manager.m_7217_((PreparableReloadListener)JSON_HIGHLIGHTER_MANAGER);
        manager.m_7217_((PreparableReloadListener)RESOURCE_PRESET_HANDLER);
        manager.m_7217_((PreparableReloadListener)RESOURCE_HOT_KEY_GROUP_HANDLER);
        JSON_HIGHLIGHTER_MANAGER.registerHighlighter(new HighlighterManagerImpl.LanguageHighlighterImpl<RegexParser>("regex", RegexLexer::new, RegexParser::new, RegexParser::root));
        JSON_HIGHLIGHTER_MANAGER.registerHighlighter(new HighlighterManagerImpl.LanguageHighlighterImpl<SNBTParser>("snbt", SNBTLexer::new, SNBTParser::new, SNBTParser::root));
        manager.m_7217_((PreparableReloadListener)LANGUAGE_RELOAD_MANAGER);
    }

    @SubscribeEvent
    protected static void onRegisterSounds(RegisterEvent event) {
        event.register(ForgeRegistries.SOUND_EVENTS.getRegistryKey(), r -> {
            UI_TAP = SimpleConfigMod.regSound((RegisterEvent.RegisterHelper<SoundEvent>)r, new ResourceLocation(MOD_ID, "ui_tap"));
            UI_DOUBLE_TAP = SimpleConfigMod.regSound((RegisterEvent.RegisterHelper<SoundEvent>)r, new ResourceLocation(MOD_ID, "ui_double_tap"));
        });
    }

    protected static SoundEvent regSound(RegisterEvent.RegisterHelper<SoundEvent> registry, ResourceLocation name) {
        SoundEvent event = SoundEvent.m_262824_((ResourceLocation)name);
        registry.register(name, (Object)event);
        return event;
    }

    static {
        JSON_HIGHLIGHTER_MANAGER = HighlighterManagerImpl.INSTANCE;
        RESOURCE_PRESET_HANDLER = SimpleConfigResourcePresetHandler.INSTANCE;
        RESOURCE_HOT_KEY_GROUP_HANDLER = ResourceConfigHotKeyGroupHandler.INSTANCE;
        LANGUAGE_RELOAD_MANAGER = SimpleConfigModConfig.LanguageReloadManager.INSTANCE;
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD, modid="simpleconfig")
    public static class KeyBindings {
        public static final String CATEGORY = "Simple Config";
        public static KeyMapping SEARCH;
        public static KeyMapping PREV_TYPE;
        public static KeyMapping NEXT_TYPE;
        public static KeyMapping PREV_PAGE;
        public static KeyMapping NEXT_PAGE;
        public static KeyMapping UNDO;
        public static KeyMapping REDO;
        public static KeyMapping PREV_ERROR;
        public static KeyMapping NEXT_ERROR;
        public static KeyMapping PREV_EDITED;
        public static KeyMapping NEXT_EDITED;
        public static KeyMapping SAVE;
        public static KeyMapping RESET_RESTORE;
        public static KeyMapping HOTKEY;
        public static KeyMapping HELP;

        @SubscribeEvent
        public static void register(RegisterKeyMappingsEvent e) {
            SEARCH = KeyBindings.reg(e, "search", KeyModifier.CONTROL, 70);
            PREV_TYPE = KeyBindings.reg(e, "prev_type", KeyModifier.ALT, 266);
            NEXT_TYPE = KeyBindings.reg(e, "next_type", KeyModifier.ALT, 267);
            PREV_PAGE = KeyBindings.reg(e, "prev_page", KeyModifier.CONTROL, 266);
            NEXT_PAGE = KeyBindings.reg(e, "next_page", KeyModifier.CONTROL, 267);
            UNDO = KeyBindings.reg(e, "undo", KeyModifier.CONTROL, 90);
            REDO = KeyBindings.reg(e, "redo", KeyModifier.CONTROL, 89);
            PREV_ERROR = KeyBindings.reg(e, "prev_error", KeyModifier.SHIFT, 290);
            NEXT_ERROR = KeyBindings.reg(e, "next_error", 290);
            PREV_EDITED = KeyBindings.reg(e, "prev_edited", KeyModifier.SHIFT, 296);
            NEXT_EDITED = KeyBindings.reg(e, "next_edited", 296);
            SAVE = KeyBindings.reg(e, "save", KeyModifier.CONTROL, 83);
            RESET_RESTORE = KeyBindings.reg(e, "reset_restore", KeyModifier.CONTROL, 82);
            HOTKEY = KeyBindings.reg(e, "hotkey", KeyModifier.CONTROL, 72);
            HELP = KeyBindings.reg(e, "help", KeyModifier.CONTROL, 81);
        }

        @SubscribeEvent
        public static void register(FMLClientSetupEvent event) {
            event.enqueueWork(() -> MinecraftForge.EVENT_BUS.register((Object)ExtendedKeyBindDispatcher.INSTANCE));
        }

        @OnlyIn(value=Dist.CLIENT)
        private static KeyMapping reg(RegisterKeyMappingsEvent event, String name, int keyCode) {
            KeyMapping binding = new KeyMapping("simpleconfig.key." + name, (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.Type.KEYSYM.m_84895_(keyCode), CATEGORY);
            event.register(binding);
            return binding;
        }

        @OnlyIn(value=Dist.CLIENT)
        private static KeyMapping reg(RegisterKeyMappingsEvent event, String name, KeyModifier modifier, int keyCode) {
            KeyMapping binding = new KeyMapping("simpleconfig.key." + name, (IKeyConflictContext)KeyConflictContext.GUI, modifier, InputConstants.Type.KEYSYM.m_84895_(keyCode), CATEGORY);
            event.register(binding);
            return binding;
        }
    }
}

