/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.anvil;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.IExtendableSmithingRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.ISmithingCategoryExtension;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class SmithingRecipeCategory
implements IRecipeCategory<SmithingRecipe>,
IExtendableSmithingRecipeCategory {
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slot;
    private final IDrawable recipeArrow;
    private final Map<Class<? extends SmithingRecipe>, ISmithingCategoryExtension<?>> extensions = new HashMap();

    public SmithingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(108, 28);
        this.slot = guiHelper.getSlotDrawable();
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)Blocks.f_50625_));
        Textures textures = Internal.getTextures();
        this.recipeArrow = textures.getRecipeArrow();
    }

    @Override
    public RecipeType<SmithingRecipe> getRecipeType() {
        return RecipeTypes.SMITHING;
    }

    @Override
    public Component getTitle() {
        return Blocks.f_50625_.m_49954_();
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, SmithingRecipe recipe, IFocusGroup focuses) {
        ISmithingCategoryExtension<SmithingRecipe> extension = this.getExtension(recipe);
        if (extension == null) {
            return;
        }
        IRecipeSlotBuilder templateSlot = builder.addSlot(RecipeIngredientRole.INPUT, 1, 6).setBackground(this.slot, -1, -1);
        IRecipeSlotBuilder baseSlot = builder.addSlot(RecipeIngredientRole.INPUT, 19, 6).setBackground(this.slot, -1, -1);
        IRecipeSlotBuilder additionSlot = builder.addSlot(RecipeIngredientRole.INPUT, 37, 6).setBackground(this.slot, -1, -1);
        IRecipeSlotBuilder outputSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, 91, 6).setBackground(this.slot, -1, -1);
        extension.setTemplate(recipe, templateSlot);
        extension.setBase(recipe, baseSlot);
        extension.setAddition(recipe, additionSlot);
        extension.setOutput(recipe, outputSlot);
    }

    @Override
    public void onDisplayedIngredientsUpdate(SmithingRecipe recipe, List<IRecipeSlotDrawable> recipeSlots, IFocusGroup focuses) {
        IRecipeSlotDrawable templateSlot = recipeSlots.get(0);
        IRecipeSlotDrawable baseSlot = recipeSlots.get(1);
        IRecipeSlotDrawable additionSlot = recipeSlots.get(2);
        IRecipeSlotDrawable outputSlot = recipeSlots.get(3);
        List<IFocus<?>> outputFocuses = focuses.getFocuses(RecipeIngredientRole.OUTPUT).toList();
        if (outputFocuses.isEmpty()) {
            ItemStack template = templateSlot.getDisplayedItemStack().orElse(ItemStack.f_41583_);
            ItemStack base = baseSlot.getDisplayedItemStack().orElse(ItemStack.f_41583_);
            ItemStack addition = additionSlot.getDisplayedItemStack().orElse(ItemStack.f_41583_);
            Container recipeInput = SmithingRecipeCategory.createInput(template, base, addition);
            ItemStack output = RecipeUtil.assembleResultItem(recipeInput, recipe);
            outputSlot.createDisplayOverrides().addItemStack(output);
        } else {
            ItemStack output = outputSlot.getDisplayedItemStack().orElse(ItemStack.f_41583_);
            ItemStack base = new ItemStack((ItemLike)output.m_41720_());
            ItemStack template = templateSlot.getDisplayedItemStack().orElse(ItemStack.f_41583_);
            ItemStack addition = additionSlot.getDisplayedItemStack().orElse(ItemStack.f_41583_);
            baseSlot.createDisplayOverrides().addItemStack(base);
            Container recipeInput = SmithingRecipeCategory.createInput(template, base, addition);
            output = RecipeUtil.assembleResultItem(recipeInput, recipe);
            outputSlot.createDisplayOverrides().addItemStack(output);
        }
    }

    private static Container createInput(ItemStack template, ItemStack base, ItemStack addition) {
        SimpleContainer container = new SimpleContainer(3);
        container.m_6836_(0, template);
        container.m_6836_(1, base);
        container.m_6836_(2, addition);
        return container;
    }

    @Override
    public void draw(SmithingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.recipeArrow.draw(guiGraphics, 61, 7);
    }

    @Override
    public boolean isHandled(SmithingRecipe recipe) {
        ISmithingCategoryExtension extension = this.getExtension(recipe);
        return extension != null;
    }

    @Override
    public ResourceLocation getRegistryName(SmithingRecipe recipe) {
        return recipe.m_6423_();
    }

    @Override
    public <R extends SmithingRecipe> void addExtension(Class<? extends R> recipeClass, ISmithingCategoryExtension<R> extension) {
        ErrorUtil.checkNotNull(recipeClass, "recipeClass");
        ErrorUtil.checkNotNull(extension, "extension");
        if (this.extensions.containsKey(recipeClass)) {
            throw new IllegalArgumentException("An extension has already been registered for: " + recipeClass);
        }
        this.extensions.put(recipeClass, extension);
    }

    @Nullable
    private <R extends SmithingRecipe> ISmithingCategoryExtension<? super R> getExtension(SmithingRecipe recipe) {
        ISmithingCategoryExtension<?> extension = this.extensions.get(recipe.getClass());
        if (extension != null) {
            return extension;
        }
        for (Map.Entry<Class<SmithingRecipe>, ISmithingCategoryExtension<?>> e : this.extensions.entrySet()) {
            if (!e.getKey().isInstance(recipe)) continue;
            return e.getValue();
        }
        return null;
    }
}

