/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.jei.tags;

import java.util.List;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IScrollGridWidgetFactory;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.common.util.StringUtil;
import mezz.jei.library.plugins.jei.tags.ITagInfoRecipe;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.StringUtils;

public class TagInfoRecipeCategory<R extends ITagInfoRecipe, T extends RecipeType<R>>
implements IRecipeCategory<R> {
    private static final int WIDTH = 142;
    private static final int HEIGHT = 110;
    private final IDrawable background;
    private final IDrawable icon;
    private final T recipeType;
    private final Component localizedName;
    private final ImmutableRect2i nameArea;
    private final IScrollGridWidgetFactory<?> scrollGridFactory;
    private final IDrawableStatic slotDrawable;

    public TagInfoRecipeCategory(IGuiHelper guiHelper, T recipeType, ResourceLocation registryLocation) {
        this.background = guiHelper.createBlankDrawable(142, 110);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)Items.f_42656_));
        this.slotDrawable = guiHelper.getSlotDrawable();
        this.recipeType = recipeType;
        String registryName = StringUtils.capitalize((String)registryLocation.m_135815_());
        this.localizedName = Component.m_237110_((String)"gui.jei.category.tagInformation", (Object[])new Object[]{registryName});
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        int titleHeight = 9;
        this.nameArea = new ImmutableRect2i(22, 5, 120, titleHeight);
        this.scrollGridFactory = guiHelper.createScrollGridFactory(7, 5);
        ScreenRectangle gridArea = this.scrollGridFactory.getArea();
        this.scrollGridFactory.setPosition((142 - gridArea.f_263770_()) / 2, 20);
    }

    public T getRecipeType() {
        return this.recipeType;
    }

    @Override
    public Component getTitle() {
        return this.localizedName;
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, R recipe, IFocusGroup focuses) {
        ScreenRectangle gridArea = this.scrollGridFactory.getArea();
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, gridArea.f_263846_().f_263719_() + 1, 1).addTypedIngredients((List)recipe.getTypedIngredients())).setBackground(this.slotDrawable, -1, -1);
        for (ITypedIngredient<?> stack : recipe.getTypedIngredients()) {
            builder.addSlotToWidget(RecipeIngredientRole.OUTPUT, this.scrollGridFactory).addTypedIngredient(stack);
        }
    }

    @Override
    public void draw(R recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        TagKey<?> tag = recipe.getTag();
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        Component tagName = renderHelper.getName(tag);
        if (font.m_92852_((FormattedText)tagName) > this.nameArea.width()) {
            tagName = StringUtil.truncateStringToWidth(tagName, this.nameArea.width(), font);
        }
        ImmutableRect2i nameArea = MathUtil.centerTextArea(this.nameArea, font, (FormattedText)tagName);
        guiGraphics.m_280614_(font, tagName, nameArea.x(), nameArea.getY(), -11513776, false);
    }

    @Override
    public List<Component> getTooltipStrings(R recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (this.nameArea.contains(mouseX, mouseY)) {
            TagKey<?> tag = recipe.getTag();
            IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
            Component tagName = renderHelper.getName(tag);
            return List.of(tagName, Component.m_237113_((String)tag.f_203868_().toString()).m_130940_(ChatFormatting.GRAY));
        }
        return List.of();
    }

    @Override
    public void getTooltip(ITooltipBuilder tooltip, R recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (!this.nameArea.contains(mouseX, mouseY)) {
            return;
        }
        TagKey<?> tag = recipe.getTag();
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        Component tagName = renderHelper.getName(tag);
        tooltip.add((FormattedText)tagName);
        tooltip.add((FormattedText)Component.m_237113_((String)tag.f_203868_().toString()).m_130940_(ChatFormatting.GRAY));
    }

    @Override
    public ResourceLocation getRegistryName(R recipe) {
        return recipe.getTag().f_203868_();
    }
}

